﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Samochodowka" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Rozliczenie oplat za srodowisko</title>
	<script runat="server">

		private EkoPaliwoSilnika ostatniePaliwoSilnika;
		private int numerator;

		private Dictionary<EkoPaliwoSilnika, Decimal> zuzycie;
		private Log log;


		private void OnContextLoad(Object sender, EventArgs args)
		{
			//
			// Nagłówek
			//
			ReportHeaderId.Visible = Prms.Header;
			ReportHeaderId["OKRES"] = Prms.Okres.ToString();
			ReportHeaderId["REFDATE"] = ReferenceDate.ToString();

			LabelYearId.EditValue = ReferenceDate.Year.ToString();

			//
			// Sumowanie danych
			//

			zuzycie = new Dictionary<EkoPaliwoSilnika, decimal>();
			log = null;

			var kosztyView = SamochodowkaModule.GetInstance(dc).KosztyEP.CreateView();
			kosztyView.Condition &= new FieldCondition.Contain("Data", Prms.Okres);
			kosztyView.Condition &= new FieldCondition.Null("RodzajPaliwa", false);

			foreach (KosztEP koszt in kosztyView)
			{
				EkoPaliwoSilnika paliwoSilnika = analizujKosztEP(koszt);
				if (paliwoSilnika == null)
					continue;

				if (zuzycie.ContainsKey(paliwoSilnika))
					zuzycie[paliwoSilnika] += koszt.IloscPaliwa;
				else
					zuzycie[paliwoSilnika] = koszt.IloscPaliwa;
			}

			//
			// Wydruk
			//

			ostatniePaliwoSilnika = null;
			numerator = 0;

			var paliwaSilnikow = SamochodowkaModule.GetInstance(dc).EkoPaliwaSilnika.WgSilnik.CreateView();
			Grid.DataSource = paliwaSilnikow;
		}


		private EkoPaliwoSilnika analizujKosztEP(KosztEP koszt)
		{
			if (koszt.IloscPaliwa == 0m)
			{
				writeLog(koszt, "Zerowa ilość paliwa.");
				return null;
			}

			if (koszt.Pojazd.RodzajSilnika == null)
			{
				writeLog(koszt, "Pojazd {0} nie ma określonego rodzaju silnika.", koszt.Pojazd);
				return null;
			}

			EkoPaliwoSilnika paliwoSilnika = koszt.Module.EkoPaliwaSilnika.WgSilnik[koszt.Pojazd.RodzajSilnika, koszt.RodzajPaliwa];
			if (paliwoSilnika == null)
			{
				writeLog(koszt, "Dla rodzaju silnika {0} nie dopuszczono rodzaju paliwa {1}.", koszt.Pojazd.RodzajSilnika, koszt.RodzajPaliwa);
				return null;
			}

			return paliwoSilnika;
		}


		private void writeLog(KosztEP koszt, String messageFmt, params Object[] messagePrms)
		{
			if (log == null)
				log = new Log("Samochodówka - korzystanie ze środowiska", true);
			log.WriteLine("Dokument kosztowy: {0} --> {1}", koszt.Dokument, String.Format(messageFmt, messagePrms));
		}


		private void OnBeforeRow(Object sender, RowEventArgs args)
		{
			EkoPaliwoSilnika paliwoSilnika = (EkoPaliwoSilnika)args.Row;
			if (Prms.Niezerowe && !zuzycie.ContainsKey(paliwoSilnika))
			{
				args.VisibleRow = false;
				return;
			}

			if (ostatniePaliwoSilnika == null || ostatniePaliwoSilnika.Silnik.ID != paliwoSilnika.Silnik.ID)
			{
				CmId.EditValue = ++numerator;
				CmSilnik.EditValue = paliwoSilnika.Silnik.Opis;

				ostatniePaliwoSilnika = paliwoSilnika;
			}
			else
			{
				CmId.EditValue = String.Empty;
				CmSilnik.EditValue = String.Empty;
			}

			if (zuzycie.ContainsKey(paliwoSilnika))
			{
				Decimal iloscDm3 = zuzycie[paliwoSilnika];
				Decimal iloscMg = Decimal.Round(iloscDm3 * (decimal)paliwoSilnika.Paliwo.Gestosc / 1000m, 6);
				Decimal stawka = ((EkoPaliwoStawka)paliwoSilnika.Historia[ReferenceDate]).Stawka.Value;

				CmZuzycie.EditValue = iloscMg;
				CmStawka.EditValue = stawka;
				CmWartosc.EditValue = Decimal.Round(iloscMg * stawka, 2);
			}
		}


		[Context]
		public Params Prms { get; set; }


		public class Params : ContextBase
		{
			private Boolean niezerowe = true;
			private Boolean header = true;
			private FromTo okres;


			[Priority(10)]
			[Caption("Za okres")]
			public FromTo Okres
			{
				get { return okres; }
				set
				{
					okres = value;
					checkOkres();
					OnChanged();
				}
			}


			[Priority(20)]
			[Caption("Drukuj nagłówek")]
			public Boolean Header
			{
				get { return header; }
				set { header = value; OnChanged(); }
			}


			[Priority(30)]
			[Caption("Tylko niezerowe")]
			public Boolean Niezerowe
			{
				get { return niezerowe; }
				set { niezerowe = value; OnChanged(); }
			}


			public Params(Context ctx) :
				base(ctx)
			{
				KosztyEP.Params p = ctx[typeof(KosztyEP.Params), false] as KosztyEP.Params;
				okres = p != null ? p.Okres : FromTo.Year(Date.Today);
				checkOkres();
			}


			private void checkOkres()
			{ if (okres == FromTo.Empty || okres == FromTo.All) okres = FromTo.Year(Date.Today); }
		}


		private Date ReferenceDate
		{ get { return Prms.Okres.From; } }
		

	</script>
</head>
<body>
	<form method="post" runat="server">
		<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" landscape="true" />
		<eb:ReportHeader runat="server" ID="ReportHeaderId" Title="Rozliczenie opłat za środowisko|</STRONG>Okres:<STRONG> %OKRES%|</STRONG>Stawki na dzień:<STRONG> %REFDATE%" />

		<p style="font-family:Tahoma; font-size:10pt;">
			<b>Tabela D<br />Wprowadzanie gazów lub pyłów do powietrza z procesów spalania paliw w silnikach spalinowych - rok <ea:datalabel runat="server" id="LabelYearId" /></b>
		</p>

		<ea:grid id="Grid" runat="server" onbeforerow="OnBeforeRow" SumText="Wysokość opłaty ogółem [zł]" >
			<Columns>
				<ea:GridColumn runat="server" ID="CmId" Width="4" Align="Center" Caption="Lp." />
				<ea:GridColumn runat="server" ID="CmSilnik" Caption="Rodzaj silnika spalinowego" Total="Info" Align="Left" />
				<ea:GridColumn runat="server" Width="25" DataMember="Paliwo.Nazwa" Caption="Rodzaj paliwa" />
				<ea:GridColumn runat="server" ID="CmZuzycie" Width="17" Format="{0:n6}" Align="Right" Caption="Zużycie paliwa [Mg]" />
				<ea:GridColumn runat="server" ID="CmStawka" Format="{0:n2}" Width="17" Align="Right" Caption="Jednostkowa stawka opłaty [zł/Mg]" />
				<ea:GridColumn runat="server" ID="CmWartosc" Width="17" Align="Right" Caption="Wysokość opłaty [zł]" Total="Sum" />
			</Columns>
		</ea:grid>

		<p style="font-family:Tahoma; font-size:8pt;">
			<b><u>Pouczenie:</u></b> <br />
			Zawarte w wykazie informacje o wysokości należnych opłat stanowią podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji
			(Dz. U. z 2005 r. Nr 229, poz. 1954, z 2006 r. Nr 104, poz. 708 i 711, Nr 133, poz. 935, Nr 157, poz. 1119 i Nr 187, poz. 1381, z 2007 r. Nr 89, poz. 589, Nr 115, poz. 794, Nr 176, poz. 1243 i Nr 192, poz. 1378, z 2008 r. Nr 209, poz. 1318 oraz z 2009 r. Nr 3, poz. 11 i Nr 39, poz. 308).				
		</p>

		<eb:ReportFooter id="ReportFooter1" runat="server">
			<Subtitles>
				<eb:FooterSubtitle SubtitleType="Data" Width="20"></eb:FooterSubtitle>
				<eb:FooterSubtitle SubtitleType="Text" Caption="(podpis osoby wypełniającej)" Width="40"></eb:FooterSubtitle>
				<eb:FooterSubtitle SubtitleType="Text" Caption="(podpis osoby upoważnionej do reprezentowania podmiotu)" Width="40"></eb:FooterSubtitle>
			</Subtitles>
		</eb:ReportFooter>
	</form>
</body>
</html>
